/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import sedona.dasp.DaspMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class ReceiveQueue {
    private DaspMessage head;
    private DaspMessage tail;
    private int size;
    private int peak;
    private boolean isAlive;
    private int max;

    public final synchronized boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public final synchronized int size() {
        return this.size;
    }

    public final int peak() {
        return this.peak;
    }

    public final int max() {
        return this.max;
    }

    public final synchronized void kill() {
        this.isAlive = false;
        this.notifyAll();
    }

    public final synchronized DaspMessage dequeue(long l) throws InterruptedException {
        while (this.isAlive && this.size == 0 && l != 0L) {
            if (l == (long)-1) {
                this.wait();
                continue;
            }
            this.wait(l);
            break;
        }
        DaspMessage daspMessage = this.head;
        if (daspMessage == null) {
            return null;
        }
        this.head = daspMessage.next;
        if (this.head == null) {
            this.tail = null;
        }
        daspMessage.next = null;
        --this.size;
        this.notifyAll();
        return daspMessage;
    }

    public final synchronized void enqueue(DaspMessage daspMessage) throws FullException {
        if (this.isAlive && this.size >= this.max()) {
            throw new FullException();
        }
        if (daspMessage.next != null) {
            throw new IllegalStateException();
        }
        if (this.tail == null) {
            this.head = this.tail = daspMessage;
        } else {
            this.tail.next = daspMessage;
            this.tail = daspMessage;
        }
        ++this.size;
        if (this.size > this.peak) {
            this.peak = this.size;
        }
        this.notifyAll();
    }

    public final synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public final String toString() {
        return "MsgQueue size=" + this.size + " peak=" + this.peak + " max=" + this.max();
    }

    private final /* synthetic */ void this() {
        this.isAlive = true;
    }

    ReceiveQueue(int n) {
        this.this();
        this.max = n;
    }

    static class FullException
    extends Exception {
        FullException() {
        }
    }
}

